import 'package:admin_desktop/app_constants.dart';
import 'package:admin_desktop/infrastructure/services/app_helpers.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';

class CustomSquare extends StatelessWidget {
  final double size;
  final num? number;
  final num? count;
  final String title;

  const CustomSquare({super.key, this.size = 180,this.count ,this.number,required this.title});

  @override
  Widget build(BuildContext context) {
    return Container(
      width: size.w,
      height: size.r,
      decoration: BoxDecoration(
        color: Style.white,
        borderRadius: BorderRadius.circular(AppConstants.radius),
      ),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          count==null ? 
              Text(AppHelpers.numberFormat(number: number),style: Style.interBold()) :
          Text(
            "${count ?? 0}",
            style: Style.interBold(),
          ),
          20.verticalSpace,
          Text(
            AppHelpers.getTranslation(title),
            style: Style.interNormal(),
          )
        ],
      )
    );
  }
}
